package edu.uky.ai.chess.ex;

import java.util.ArrayList;
import java.util.Random;

import edu.uky.ai.SearchBudgetExceededException;
import edu.uky.ai.chess.Agent;
import edu.uky.ai.chess.state.State;

/**
 * This agent chooses a next move randomly from among the possible legal moves.
 * 
 * @author Your Name
 */
public class ExampleAgent extends Agent {

	/** A random number generator */
	private final Random random = new Random(0);
	
	/**
	 * Constructs a new random agent. You should change the string below from
	 * "Example" to your ID. You should also change the name of this class. In
	 * Eclipse, you can do that easily by right-clicking on this file
	 * (RandomAgent.java) in the Package Explorer and choosing Refactor > Rename.
	 */
	public ExampleAgent() {
		super("Example");
	}

	@Override
	protected State chooseMove(State current) {
		// This list will hold all the children state (all possible next moves).
		ArrayList<State> children = new ArrayList<>();
		// Iterate through each child and put it in the list. We wrap this in
		// a try/catch block in case the search budget runs out and causes an
		// exception to be thrown.
		try {
			for(State child : current.next())
				children.add(child);
		}
		catch(SearchBudgetExceededException e) {
			e.printStackTrace();
		}
		// Pick a next move at random.
		return children.get(random.nextInt(children.size()));
	}
}
